document.addEventListener('DOMContentLoaded', () => {
    
    // Mobil Menü
    const hamburger = document.querySelector('.hamburger');
    const menuOverlay = document.querySelector('.mobile-menu-overlay');
    const menuLinks = document.querySelectorAll('.m-link, .btn-mobile-call');

    if(hamburger) {
        hamburger.addEventListener('click', () => {
            menuOverlay.classList.toggle('active');
            hamburger.classList.toggle('is-active'); // Hamburger animasyonu için
        });
    }

    menuLinks.forEach(link => {
        link.addEventListener('click', () => {
            menuOverlay.classList.remove('active');
            hamburger.classList.remove('is-active');
        });
    });

    // Scroll Reveal (Animasyon)
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, { threshold: 0.1 });

    const cards = document.querySelectorAll('.service-card, .split-text, .split-img');
    cards.forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = 'all 0.6s ease-out';
        observer.observe(card);
    });

});